<?php
/**
 * Class Category
 *
 * @author ARSENE TEKEU
 * @version 1.0
 * @date    Mai 2025
 * chaque catégorie contient :
 * - un identifiant unique,
 * - un nom,
 * - une description,
 * @property int $id
 * @property string $nom
 * @property string $description
 */

require_once __DIR__ . '/../config/database.php';

class Category {
    private $id;
    private $nom;
    private $description;
    
    /**
     * Récupérer toutes les catégories
     * Summary of getAll
     * @return array
     */
    public static function getAll() {
        $conn = connectDB();
        
        try {
            $stmt = $conn->prepare("SELECT * FROM categories ORDER BY nom");
            $stmt->execute();
            
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            return [];
        }
    }
    
    /**
     * Récupérer une catégorie par son ID
     * Summary of getById
     * @param mixed $id
     */
    public static function getById($id) {
        $conn = connectDB();
        
        try {
            $stmt = $conn->prepare("SELECT * FROM categories WHERE id = :id");
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            
            if ($stmt->rowCount() === 1) {
                return $stmt->fetch(PDO::FETCH_ASSOC);
            }
            return null;
        } catch (PDOException $e) {
            return null;
        }
    }
    
    /**
     * Créer une nouvelle catégorie
     * Summary of create
     * @param mixed $nom
     * @param mixed $description
     * @return bool
     */
    public static function create($nom, $description) {
        $conn = connectDB();
        
        try {
            $stmt = $conn->prepare("INSERT INTO categories (nom, description) VALUES (:nom, :description)");
            $stmt->bindParam(':nom', $nom);
            $stmt->bindParam(':description', $description);
            $stmt->execute();
            
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }
}
?>